<?php

namespace Wolfie\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceData extends Model 
{

    protected $table = 'services_data';
    public $timestamps = true;
    protected $fillable = array('question', 'label', 'type');

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function options()
    {
        return $this->hasMany('ServiceDataOptions', 'service_data_id');
    }

}